/**************************************************************************/
/*                                                                        */
/* Module:             INTS_SKL.C                                         */
/*                                                                        */
/* Function:           Interactive Service Interface                      */
/*                     -- Skeleton/sample for your function declarations  */
/*                                                                        */
/* Author:             W. Reichert, D.3274                                */
/*                                                                        */
/* Date created:       1992-03-01                                         */
/*                                                                        */
/* Classification:     IBM Internal Use Only                              */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/* How to define the functions you wish to test                           */
/* --------------------------------------------                           */
/*                                                                        */
/* Assuming the functions you want to test are named SampleFunc1(...),    */
/* SampleFunc2(...) and SampleFunc3(...) with the corresponding library   */
/* file SAMPLE.LIB.                                                       */
/*                                                                        */
/* 1.  Write the function declaration routines ISISampleFunc1(), ...      */
/*     as shown below in this file.                                       */
/*                                                                        */
/*     Each declartion consists of three parts (see below):               */
/*     - Get input values                                                 */
/*     - Invoke function                                                  */
/*     - Show output values                                               */
/*                                                                        */
/* 2.  Identify the functions to INTSRV. The following entries are made   */
/*     in INTS_INI.H.                                                     */
/*                                                                        */
/*     a) Name the function declaration routines:                         */
/*                                                                        */
/*        >>> USHORT ISISampleFunc1();                                    */
/*        >>> USHORT ISISampleFunc2();                                    */
/*        >>> USHORT ISISampleFunc3();                                    */
/*                                                                        */
/*     b) Associate the function names and the function declaration       */
/*        routines (structure ISI_FUNC defined in INTS_INI.H):            */
/*                                                                        */
/*        >>> "SampleFunc1",   ISISampleFunc1,                            */
/*        >>> "SampleFunc2",   ISISampleFunc2,                            */
/*        >>> "SampleFunc3",   ISISampleFunc3,                            */
/*                                                                        */
/*             |               |                                          */
/*             |               + This is the (address of the) function    */
/*             |                 declaration routine                      */
/*             |                                                          */
/*             + This is the name how you call                            */
/*               the function interactively                               */
/*                                                                        */
/* 3.  Check that the makefile INTSRV.MAK contains your function defini-  */
/*     tion file (name of the object file, eg. INTS_SKL.OBJ):             */
/*                                                                        */
/*        >>>  OBJ = ... INTS_SKL.OBJ                                     */
/*                                                                        */
/*     In addition the library containing your functions must be named    */
/*     (e.g. SAMPLE.LIB):                                                 */
/*                                                                        */
/*        >>>  APPLIB = ... SAMPLE.LIB                                       */
/*                                                                        */
/*     Compile and link:                                                  */
/*                                                                        */
/*        >>>  MAKE -f INTSRV.MAK                                         */
/*                                                                        */
/* That's all.                                                            */
/*                                                                        */
/**************************************************************************/

/**************************************************************************/
/* Include files                                                          */
/**************************************************************************/

#include <os2.h>
#include <string.h>

#include "INTSRV.H"
#include "INTS_INI.H"

/****** ISISampleFunc1() **************************************************/
/*                                                                        */
/* For this sample declaration it is assumed that the function to be      */
/* tested is defined as:                                                  */
/*                                                                        */
/*      BOOL SampleFunc1(                                                 */
/*          SHORT  sNumber1,           -- in:  1st number                 */
/*          SHORT  sNumber2,           -- in:  2nd number                 */
/*          SHORT *psResult);          -- out: sum of number 1 and 2      */
/*                                     -- RC:  1 (TRUE) always            */
/*                                                                        */
/**************************************************************************/

USHORT ISISampleFunc1()
{
    SHORT  sNumber1;                   /* 1st number                 (in) */
    SHORT  sNumber2;                   /* 2nd number                 (in) */
    SHORT  sResult = 0;                /* Result: sNumber1+sNumber2 (out) */
    PSHORT psResult = &sResult;        /* Pointer to sResult              */
    BOOL   fRC = 0;                    /* Return code of function call    */

    /*** Get all input values ***/

    GetValue(TYPE_SHORT, "sNumber1", &sNumber1, 0, 0);
    GetValue(TYPE_SHORT, "sNumber2", &sNumber2, 0, 0);

    /*** Call the function ***/

    COND_SECT("SampleFunc1");
//    fRC = SampleFunc1(sNumber1, sNumber2, psResult);
                       /* Instead of calling the function, here the       */
                       /* output is generated for this sample ...         */
                       *psResult = (SHORT)(sNumber1 + sNumber2); fRC = TRUE;
    END_COND_SECT;

    /*** Show return code and output value (twice: decimal and hex) ***/

    ShowValue(TYPE_BOOL,  "SampleFunc1(): fRC", &fRC,     0L, 0);
    ShowValue(TYPE_SHORT, "sResult",            &sResult, 0L, 0);
    ShowValue(TYPE_SHORT, "sResult",            &sResult, 0L, DISPLAY_HEX);

    return 0;
}

/****** ISISampleFunc2() **************************************************/
/*                                                                        */
/* For this sample declaration it is assumed that the function to be      */
/* tested is defined as:                                                  */
/*                                                                        */
/*      UCHAR SampleFunc2(                                                */
/*          PCHAR  pchSampleBuf,       -- in/out: buffer to be filled     */
/*          UCHAR  uchFirstChar,       -- in:     first character         */
/*          INT    iSampleBufLen);     -- in:     buffer length           */
/*                                     -- RC:     last character          */
/*                                                                        */
/**************************************************************************/

USHORT ISISampleFunc2()
{
    PCHAR  pchSampleBuf;               /* Output buffer          (in/out) */
    UCHAR  uchFirstChar;               /* Charachter to start with   (in) */
    INT    iSampleBufLen;              /* Size of output buffer      (in) */
    UCHAR  uchRC = 0;                  /* Return code of function call    */

    /*** Get input values ***/

    GetValue(TYPE_INT,   "iSampleBufLen", &iSampleBufLen, 0, 0);
    GetValue(TYPE_UCHAR, "uchFirstChar",  &uchFirstChar,   0, 0);

    /*** Set size of output buffer according to specified iSampleBufLen ***/

    SetValueSize(TYPE_PCHAR, "pchSampleBuf", &pchSampleBuf,
                                               (ULONG) iSampleBufLen, 0, 0);

    /*** Call the function ***/

    COND_SECT("SampleFunc2");
//    uchRC = SampleFunc2(pchSampleBuf, uchFirstChar, iSampleBufLen);
                       /* Instead of calling the function, here the       */
                       /* output is generated for this sample ...         */
                       { INT i;
                         for (i=0, uchRC=uchFirstChar; i<iSampleBufLen; i++)
                         uchRC = pchSampleBuf[i] = (UCHAR)(i + uchFirstChar);
                       }
    END_COND_SECT;

    /*** Show return code and output value (twice: characters and hex) ***/

    ShowValue(TYPE_UCHAR, "SampleFunc2(): uchRC", &uchRC, 0L, 0);
    ShowValue(TYPE_PCHAR, "pchSampleBuf",         &pchSampleBuf,
                                                  (ULONG) iSampleBufLen, 0);
    ShowValue(TYPE_PCHAR, "pchSampleBuf",         &pchSampleBuf,
                                        (ULONG) iSampleBufLen, DISPLAY_HEX);

    return 0;
}

/****** ISISampleFunc3() **************************************************/
/*                                                                        */
/* For this sample declaration it is assumed that the function to be      */
/* tested is defined as:                                                  */
/*                                                                        */
/*      ULONG SampleFunc3(                                                */
/*          PSZ    pszSampString);     -- in: Zero-terminated string      */
/*                                     -- RC: String length               */
/*                                                                        */
/**************************************************************************/

USHORT ISISampleFunc3()
{
    PSZ    pszSampString;              /* Sample string              (in) */
    ULONG  ulRC = 0;                   /* Return code of function call    */

    /*** Get input string ***/

    GetValue(TYPE_PSZ, "pszSampString", &pszSampString, 0, 0);

    /*** Call the function ***/

    COND_SECT("SampleFunc3");
//    SampleFunc3(pszSampleString);
                       /* Instead of calling the function, here the       */
                       /* output is generated for this sample ...         */
                       if (pszSampString)
                           ulRC = (ULONG) strlen(pszSampString);
    END_COND_SECT;

    /*** Show return code ***/

    ShowValue(TYPE_ULONG,  "SampleFunc3(): ulRC", &ulRC, 0L, 0);

    return 0;
}

